# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 3
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Check if opponent's code suggests a deterministic strategy
    if "always C" in opponent_program_code or "return 'C'" in opponent_program_code:
        if current_round == 1:
            return "C"
        else:
            return "D"
    
    # Check if opponent's code suggests heavy defection bias
    if "always D" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Default strategy based on opponent's MR2 behavior
    if current_round == 1:
        return "C"
    elif current_round >= 9:
        return "D"
    else:
        if not opp_history:
            return "C"
        if opp_history[-1] == "C":
            return "C" if random.random() < 0.9 else "D"
        else:
            return "D" if random.random() < 0.9 else "C"